<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$RKP_AbsenDosen_list = new RKP_AbsenDosen_list();

// Run the page
$RKP_AbsenDosen_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$RKP_AbsenDosen_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$RKP_AbsenDosen_list->isExport()) { ?>
<script>
var fRKP_AbsenDosenlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fRKP_AbsenDosenlist = currentForm = new ew.Form("fRKP_AbsenDosenlist", "list");
	fRKP_AbsenDosenlist.formKeyCountName = '<?php echo $RKP_AbsenDosen_list->FormKeyCountName ?>';
	loadjs.done("fRKP_AbsenDosenlist");
});
var fRKP_AbsenDosenlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fRKP_AbsenDosenlistsrch = currentSearchForm = new ew.Form("fRKP_AbsenDosenlistsrch");

	// Dynamic selection lists
	// Filters

	fRKP_AbsenDosenlistsrch.filterList = <?php echo $RKP_AbsenDosen_list->getFilterList() ?>;
	loadjs.done("fRKP_AbsenDosenlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$RKP_AbsenDosen_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($RKP_AbsenDosen_list->TotalRecords > 0 && $RKP_AbsenDosen_list->ExportOptions->visible()) { ?>
<?php $RKP_AbsenDosen_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->ImportOptions->visible()) { ?>
<?php $RKP_AbsenDosen_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->SearchOptions->visible()) { ?>
<?php $RKP_AbsenDosen_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->FilterOptions->visible()) { ?>
<?php $RKP_AbsenDosen_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$RKP_AbsenDosen_list->isExport() || Config("EXPORT_MASTER_RECORD") && $RKP_AbsenDosen_list->isExport("print")) { ?>
<?php
if ($RKP_AbsenDosen_list->DbMasterFilter != "" && $RKP_AbsenDosen->getCurrentMasterTable() == "Wali_JadkulMin") {
	if ($RKP_AbsenDosen_list->MasterRecordExists) {
		include_once "Wali_JadkulMinmaster.php";
	}
}
?>
<?php
if ($RKP_AbsenDosen_list->DbMasterFilter != "" && $RKP_AbsenDosen->getCurrentMasterTable() == "Wali_JadKul_All") {
	if ($RKP_AbsenDosen_list->MasterRecordExists) {
		include_once "Wali_JadKul_Allmaster.php";
	}
}
?>
<?php } ?>
<?php
$RKP_AbsenDosen_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$RKP_AbsenDosen_list->isExport() && !$RKP_AbsenDosen->CurrentAction) { ?>
<form name="fRKP_AbsenDosenlistsrch" id="fRKP_AbsenDosenlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fRKP_AbsenDosenlistsrch-search-panel" class="<?php echo $RKP_AbsenDosen_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="RKP_AbsenDosen">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $RKP_AbsenDosen_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $RKP_AbsenDosen_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($RKP_AbsenDosen_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($RKP_AbsenDosen_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($RKP_AbsenDosen_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($RKP_AbsenDosen_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $RKP_AbsenDosen_list->showPageHeader(); ?>
<?php
$RKP_AbsenDosen_list->showMessage();
?>
<?php if ($RKP_AbsenDosen_list->TotalRecords > 0 || $RKP_AbsenDosen->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($RKP_AbsenDosen_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> RKP_AbsenDosen">
<form name="fRKP_AbsenDosenlist" id="fRKP_AbsenDosenlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="RKP_AbsenDosen">
<?php if ($RKP_AbsenDosen->getCurrentMasterTable() == "Wali_JadkulMin" && $RKP_AbsenDosen->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="Wali_JadkulMin">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Periode->getSessionValue()) ?>">
<input type="hidden" name="fk_Kelas_Akd" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kelas_Akd->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Mk" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kode_Mk->getSessionValue()) ?>">
<input type="hidden" name="fk_Kelas" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kelas->getSessionValue()) ?>">
<input type="hidden" name="fk_NIDN" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->NIDN->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kode_Fak->getSessionValue()) ?>">
<?php } ?>
<?php if ($RKP_AbsenDosen->getCurrentMasterTable() == "Wali_JadKul_All" && $RKP_AbsenDosen->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="Wali_JadKul_All">
<input type="hidden" name="fk_Thn_Akademik" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Thn_Akademik->getSessionValue()) ?>">
<input type="hidden" name="fk_Periode" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Periode->getSessionValue()) ?>">
<input type="hidden" name="fk_Kelas_Akd" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kelas_Akd->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Mk" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kode_Mk->getSessionValue()) ?>">
<input type="hidden" name="fk_NIDN" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->NIDN->getSessionValue()) ?>">
<input type="hidden" name="fk_Kelas" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kelas->getSessionValue()) ?>">
<input type="hidden" name="fk_Kode_Fak" value="<?php echo HtmlEncode($RKP_AbsenDosen_list->Kode_Fak->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_RKP_AbsenDosen" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($RKP_AbsenDosen_list->TotalRecords > 0 || $RKP_AbsenDosen_list->isGridEdit()) { ?>
<table id="tbl_RKP_AbsenDosenlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$RKP_AbsenDosen->RowType = ROWTYPE_HEADER;

// Render list options
$RKP_AbsenDosen_list->renderListOptions();

// Render list options (header, left)
$RKP_AbsenDosen_list->ListOptions->render("header", "left");
?>
<?php if ($RKP_AbsenDosen_list->Pertemuan_ke->Visible) { // Pertemuan_ke ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->Pertemuan_ke) == "") { ?>
		<th data-name="Pertemuan_ke" class="<?php echo $RKP_AbsenDosen_list->Pertemuan_ke->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_Pertemuan_ke" class="RKP_AbsenDosen_Pertemuan_ke"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->Pertemuan_ke->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Pertemuan_ke" class="<?php echo $RKP_AbsenDosen_list->Pertemuan_ke->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->Pertemuan_ke) ?>', 1);"><div id="elh_RKP_AbsenDosen_Pertemuan_ke" class="RKP_AbsenDosen_Pertemuan_ke">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->Pertemuan_ke->caption() ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->Pertemuan_ke->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->Pertemuan_ke->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->Tanggal->Visible) { // Tanggal ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->Tanggal) == "") { ?>
		<th data-name="Tanggal" class="<?php echo $RKP_AbsenDosen_list->Tanggal->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_Tanggal" class="RKP_AbsenDosen_Tanggal"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->Tanggal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tanggal" class="<?php echo $RKP_AbsenDosen_list->Tanggal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->Tanggal) ?>', 1);"><div id="elh_RKP_AbsenDosen_Tanggal" class="RKP_AbsenDosen_Tanggal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->Tanggal->caption() ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->Tanggal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->Tanggal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->JM->Visible) { // JM ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->JM) == "") { ?>
		<th data-name="JM" class="<?php echo $RKP_AbsenDosen_list->JM->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_JM" class="RKP_AbsenDosen_JM"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->JM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JM" class="<?php echo $RKP_AbsenDosen_list->JM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->JM) ?>', 1);"><div id="elh_RKP_AbsenDosen_JM" class="RKP_AbsenDosen_JM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->JM->caption() ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->JM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->JM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->JS->Visible) { // JS ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->JS) == "") { ?>
		<th data-name="JS" class="<?php echo $RKP_AbsenDosen_list->JS->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_JS" class="RKP_AbsenDosen_JS"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->JS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JS" class="<?php echo $RKP_AbsenDosen_list->JS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->JS) ?>', 1);"><div id="elh_RKP_AbsenDosen_JS" class="RKP_AbsenDosen_JS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->JS->caption() ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->JS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->JS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->Jenis->Visible) { // Jenis ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->Jenis) == "") { ?>
		<th data-name="Jenis" class="<?php echo $RKP_AbsenDosen_list->Jenis->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_Jenis" class="RKP_AbsenDosen_Jenis"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->Jenis->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Jenis" class="<?php echo $RKP_AbsenDosen_list->Jenis->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->Jenis) ?>', 1);"><div id="elh_RKP_AbsenDosen_Jenis" class="RKP_AbsenDosen_Jenis">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->Jenis->caption() ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->Jenis->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->Jenis->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->parafdosen->Visible) { // parafdosen ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->parafdosen) == "") { ?>
		<th data-name="parafdosen" class="<?php echo $RKP_AbsenDosen_list->parafdosen->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_parafdosen" class="RKP_AbsenDosen_parafdosen"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->parafdosen->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="parafdosen" class="<?php echo $RKP_AbsenDosen_list->parafdosen->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->parafdosen) ?>', 1);"><div id="elh_RKP_AbsenDosen_parafdosen" class="RKP_AbsenDosen_parafdosen">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->parafdosen->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->parafdosen->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->parafdosen->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->parafbaak->Visible) { // parafbaak ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->parafbaak) == "") { ?>
		<th data-name="parafbaak" class="<?php echo $RKP_AbsenDosen_list->parafbaak->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_parafbaak" class="RKP_AbsenDosen_parafbaak"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->parafbaak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="parafbaak" class="<?php echo $RKP_AbsenDosen_list->parafbaak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->parafbaak) ?>', 1);"><div id="elh_RKP_AbsenDosen_parafbaak" class="RKP_AbsenDosen_parafbaak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->parafbaak->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->parafbaak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->parafbaak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($RKP_AbsenDosen_list->jmlmhshadir->Visible) { // jmlmhshadir ?>
	<?php if ($RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->jmlmhshadir) == "") { ?>
		<th data-name="jmlmhshadir" class="<?php echo $RKP_AbsenDosen_list->jmlmhshadir->headerCellClass() ?>"><div id="elh_RKP_AbsenDosen_jmlmhshadir" class="RKP_AbsenDosen_jmlmhshadir"><div class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->jmlmhshadir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jmlmhshadir" class="<?php echo $RKP_AbsenDosen_list->jmlmhshadir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $RKP_AbsenDosen_list->SortUrl($RKP_AbsenDosen_list->jmlmhshadir) ?>', 1);"><div id="elh_RKP_AbsenDosen_jmlmhshadir" class="RKP_AbsenDosen_jmlmhshadir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $RKP_AbsenDosen_list->jmlmhshadir->caption() ?></span><span class="ew-table-header-sort"><?php if ($RKP_AbsenDosen_list->jmlmhshadir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($RKP_AbsenDosen_list->jmlmhshadir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$RKP_AbsenDosen_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($RKP_AbsenDosen_list->ExportAll && $RKP_AbsenDosen_list->isExport()) {
	$RKP_AbsenDosen_list->StopRecord = $RKP_AbsenDosen_list->TotalRecords;
} else {

	// Set the last record to display
	if ($RKP_AbsenDosen_list->TotalRecords > $RKP_AbsenDosen_list->StartRecord + $RKP_AbsenDosen_list->DisplayRecords - 1)
		$RKP_AbsenDosen_list->StopRecord = $RKP_AbsenDosen_list->StartRecord + $RKP_AbsenDosen_list->DisplayRecords - 1;
	else
		$RKP_AbsenDosen_list->StopRecord = $RKP_AbsenDosen_list->TotalRecords;
}
$RKP_AbsenDosen_list->RecordCount = $RKP_AbsenDosen_list->StartRecord - 1;
if ($RKP_AbsenDosen_list->Recordset && !$RKP_AbsenDosen_list->Recordset->EOF) {
	$RKP_AbsenDosen_list->Recordset->moveFirst();
	$selectLimit = $RKP_AbsenDosen_list->UseSelectLimit;
	if (!$selectLimit && $RKP_AbsenDosen_list->StartRecord > 1)
		$RKP_AbsenDosen_list->Recordset->move($RKP_AbsenDosen_list->StartRecord - 1);
} elseif (!$RKP_AbsenDosen->AllowAddDeleteRow && $RKP_AbsenDosen_list->StopRecord == 0) {
	$RKP_AbsenDosen_list->StopRecord = $RKP_AbsenDosen->GridAddRowCount;
}

// Initialize aggregate
$RKP_AbsenDosen->RowType = ROWTYPE_AGGREGATEINIT;
$RKP_AbsenDosen->resetAttributes();
$RKP_AbsenDosen_list->renderRow();
while ($RKP_AbsenDosen_list->RecordCount < $RKP_AbsenDosen_list->StopRecord) {
	$RKP_AbsenDosen_list->RecordCount++;
	if ($RKP_AbsenDosen_list->RecordCount >= $RKP_AbsenDosen_list->StartRecord) {
		$RKP_AbsenDosen_list->RowCount++;

		// Set up key count
		$RKP_AbsenDosen_list->KeyCount = $RKP_AbsenDosen_list->RowIndex;

		// Init row class and style
		$RKP_AbsenDosen->resetAttributes();
		$RKP_AbsenDosen->CssClass = "";
		if ($RKP_AbsenDosen_list->isGridAdd()) {
		} else {
			$RKP_AbsenDosen_list->loadRowValues($RKP_AbsenDosen_list->Recordset); // Load row values
		}
		$RKP_AbsenDosen->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$RKP_AbsenDosen->RowAttrs->merge(["data-rowindex" => $RKP_AbsenDosen_list->RowCount, "id" => "r" . $RKP_AbsenDosen_list->RowCount . "_RKP_AbsenDosen", "data-rowtype" => $RKP_AbsenDosen->RowType]);

		// Render row
		$RKP_AbsenDosen_list->renderRow();

		// Render list options
		$RKP_AbsenDosen_list->renderListOptions();
?>
	<tr <?php echo $RKP_AbsenDosen->rowAttributes() ?>>
<?php

// Render list options (body, left)
$RKP_AbsenDosen_list->ListOptions->render("body", "left", $RKP_AbsenDosen_list->RowCount);
?>
	<?php if ($RKP_AbsenDosen_list->Pertemuan_ke->Visible) { // Pertemuan_ke ?>
		<td data-name="Pertemuan_ke" <?php echo $RKP_AbsenDosen_list->Pertemuan_ke->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_Pertemuan_ke">
<span<?php echo $RKP_AbsenDosen_list->Pertemuan_ke->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->Pertemuan_ke->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->Tanggal->Visible) { // Tanggal ?>
		<td data-name="Tanggal" <?php echo $RKP_AbsenDosen_list->Tanggal->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_Tanggal">
<span<?php echo $RKP_AbsenDosen_list->Tanggal->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->Tanggal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->JM->Visible) { // JM ?>
		<td data-name="JM" <?php echo $RKP_AbsenDosen_list->JM->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_JM">
<span<?php echo $RKP_AbsenDosen_list->JM->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->JM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->JS->Visible) { // JS ?>
		<td data-name="JS" <?php echo $RKP_AbsenDosen_list->JS->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_JS">
<span<?php echo $RKP_AbsenDosen_list->JS->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->JS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->Jenis->Visible) { // Jenis ?>
		<td data-name="Jenis" <?php echo $RKP_AbsenDosen_list->Jenis->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_Jenis">
<span<?php echo $RKP_AbsenDosen_list->Jenis->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->Jenis->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->parafdosen->Visible) { // parafdosen ?>
		<td data-name="parafdosen" <?php echo $RKP_AbsenDosen_list->parafdosen->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_parafdosen">
<span<?php echo $RKP_AbsenDosen_list->parafdosen->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->parafdosen->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->parafbaak->Visible) { // parafbaak ?>
		<td data-name="parafbaak" <?php echo $RKP_AbsenDosen_list->parafbaak->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_parafbaak">
<span<?php echo $RKP_AbsenDosen_list->parafbaak->viewAttributes() ?>>
<?php if (!empty($RKP_AbsenDosen_list->parafbaak->getViewValue())) : ?>
    <img
        src="<?= "ttd/" . $RKP_AbsenDosen_list->parafbaak->getViewValue() ?>"
        class="img-fluid border rounded"
        alt="Tanda Tangan"
        style="max-height: 55px;"
    >
<?php else: ?>
    <!-- Tombol Paraf -->
<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modalTtd" data-id="<?php echo $RKP_AbsenDosen->id_jadwal->CurrentValue ?>">Paraf</button>

<?php endif; ?>


</span>
</span>
</td>
	<?php } ?>
	<?php if ($RKP_AbsenDosen_list->jmlmhshadir->Visible) { // jmlmhshadir ?>
		<td data-name="jmlmhshadir" <?php echo $RKP_AbsenDosen_list->jmlmhshadir->cellAttributes() ?>>
<span id="el<?php echo $RKP_AbsenDosen_list->RowCount ?>_RKP_AbsenDosen_jmlmhshadir">
<span<?php echo $RKP_AbsenDosen_list->jmlmhshadir->viewAttributes() ?>><?php echo $RKP_AbsenDosen_list->jmlmhshadir->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$RKP_AbsenDosen_list->ListOptions->render("body", "right", $RKP_AbsenDosen_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$RKP_AbsenDosen_list->isGridAdd())
		$RKP_AbsenDosen_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$RKP_AbsenDosen->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($RKP_AbsenDosen_list->Recordset)
	$RKP_AbsenDosen_list->Recordset->Close();
?>
<?php if (!$RKP_AbsenDosen_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$RKP_AbsenDosen_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $RKP_AbsenDosen_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $RKP_AbsenDosen_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($RKP_AbsenDosen_list->TotalRecords == 0 && !$RKP_AbsenDosen->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $RKP_AbsenDosen_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$RKP_AbsenDosen_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$RKP_AbsenDosen_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>

<!-- Modal -->
<div class="modal fade" id="modalTtd" tabindex="-1" role="dialog" aria-labelledby="modalTtdLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Tanda Tangan</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Tutup">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body text-center">
        <canvas id="signature-pad" width="400" height="200" style="border:1px solid #ccc;"></canvas>
      </div>
      <div class="modal-footer">
        <button id="clear" class="btn btn-warning">Reset</button>
        <button id="save" class="btn btn-success">Simpan</button>
      </div>
    </div>
  </div>
</div>

<?php include_once "footer.php"; ?>

<!-- Signature Pad -->
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
let signaturePad;
let currentIdJadwal = null;

const currentUserName = <?= json_encode(CurrentUserName()) ?>;

$(document).ready(function() {
  const canvas = document.getElementById('signature-pad');
  signaturePad = new SignaturePad(canvas);

  // Reset saat modal dibuka
  $('#modalTtd').on('show.bs.modal', function(e) {
    signaturePad.clear();
    currentIdJadwal = $(e.relatedTarget).data('id');
  });

  // Tombol Reset
  $('#clear').click(function() {
    signaturePad.clear();
  });

  // Tombol Simpan
  $('#save').click(function() {
    if (signaturePad.isEmpty()) {
      alert("Silakan tanda tangani dulu.");
      return;
    }

    const dataURL = signaturePad.toDataURL();
    $.post("simpan_ttd.php", {
      ttd: dataURL,
      id_jadwal: currentIdJadwal,
	  id_user: currentUserName
    })
    .done(function(res) {
      alert("Tanda tangan disimpan: " + res);
      $('#modalTtd').modal('hide');
      location.reload(); // reload agar tampil tanda tangan baru jika ada
    })
    .fail(function(xhr) {
      alert("Gagal menyimpan: " + xhr.responseText);
    });
  });
});
</script>


<?php
$RKP_AbsenDosen_list->terminate();
?>